/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.library.render;

import com.google.common.base.Preconditions;
import com.mojang.blaze3d.systems.RenderSystem;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredientTypeWithSubtypes;
import mezz.jei.common.platform.IPlatformFluidHelperInternal;
import net.minecraft.class_1058;
import net.minecraft.class_124;
import net.minecraft.class_1723;
import net.minecraft.class_1836;
import net.minecraft.class_2561;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_5250;
import net.minecraft.class_757;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.joml.Matrix4f;

public class FluidTankRenderer<T>
implements IIngredientRenderer<T> {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final NumberFormat nf = NumberFormat.getIntegerInstance();
    private static final int TEXTURE_SIZE = 16;
    private static final int MIN_FLUID_HEIGHT = 1;
    private final IPlatformFluidHelperInternal<T> fluidHelper;
    private final long capacity;
    private final TooltipMode tooltipMode;
    private final int width;
    private final int height;

    public FluidTankRenderer(IPlatformFluidHelperInternal<T> fluidHelper) {
        this(fluidHelper, fluidHelper.bucketVolume(), TooltipMode.ITEM_LIST, 16, 16);
    }

    public FluidTankRenderer(IPlatformFluidHelperInternal<T> fluidHelper, long capacity, boolean showCapacity, int width, int height) {
        this(fluidHelper, capacity, showCapacity ? TooltipMode.SHOW_AMOUNT_AND_CAPACITY : TooltipMode.SHOW_AMOUNT, width, height);
    }

    private FluidTankRenderer(IPlatformFluidHelperInternal<T> fluidHelper, long capacity, TooltipMode tooltipMode, int width, int height) {
        Preconditions.checkArgument((capacity > 0L ? 1 : 0) != 0, (Object)"capacity must be > 0");
        Preconditions.checkArgument((width > 0 ? 1 : 0) != 0, (Object)"width must be > 0");
        Preconditions.checkArgument((height > 0 ? 1 : 0) != 0, (Object)"height must be > 0");
        this.fluidHelper = fluidHelper;
        this.capacity = capacity;
        this.tooltipMode = tooltipMode;
        this.width = width;
        this.height = height;
    }

    @Override
    public void render(class_332 guiGraphics, T fluidStack) {
        RenderSystem.enableBlend();
        this.drawFluid(guiGraphics, this.width, this.height, fluidStack);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
    }

    private void drawFluid(class_332 guiGraphics, int width, int height, T fluidStack) {
        IIngredientTypeWithSubtypes type = this.fluidHelper.getFluidIngredientType();
        class_3611 fluid = type.getBase(fluidStack);
        if (fluid.method_15780(class_3612.field_15906)) {
            return;
        }
        this.fluidHelper.getStillFluidSprite(fluidStack).ifPresent(fluidStillSprite -> {
            int fluidColor = this.fluidHelper.getColorTint(fluidStack);
            long amount = this.fluidHelper.getAmount(fluidStack);
            long scaledAmount = amount * (long)height / this.capacity;
            if (amount > 0L && scaledAmount < 1L) {
                scaledAmount = 1L;
            }
            if (scaledAmount > (long)height) {
                scaledAmount = height;
            }
            FluidTankRenderer.drawTiledSprite(guiGraphics, width, height, fluidColor, scaledAmount, fluidStillSprite);
        });
    }

    private static void drawTiledSprite(class_332 guiGraphics, int tiledWidth, int tiledHeight, int color, long scaledAmount, class_1058 sprite) {
        RenderSystem.setShaderTexture((int)0, (class_2960)class_1723.field_21668);
        Matrix4f matrix = guiGraphics.method_51448().method_23760().method_23761();
        FluidTankRenderer.setGLColorFromInt(color);
        int xTileCount = tiledWidth / 16;
        int xRemainder = tiledWidth - xTileCount * 16;
        long yTileCount = scaledAmount / 16L;
        long yRemainder = scaledAmount - yTileCount * 16L;
        int yStart = tiledHeight;
        for (int xTile = 0; xTile <= xTileCount; ++xTile) {
            int yTile = 0;
            while ((long)yTile <= yTileCount) {
                int width = xTile == xTileCount ? xRemainder : 16;
                long height = (long)yTile == yTileCount ? yRemainder : 16L;
                int x = xTile * 16;
                int y = yStart - (yTile + 1) * 16;
                if (width > 0 && height > 0L) {
                    long maskTop = 16L - height;
                    int maskRight = 16 - width;
                    FluidTankRenderer.drawTextureWithMasking(matrix, x, y, sprite, maskTop, maskRight, 100.0f);
                }
                ++yTile;
            }
        }
    }

    private static void setGLColorFromInt(int color) {
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        float alpha = (float)(color >> 24 & 0xFF) / 255.0f;
        RenderSystem.setShaderColor((float)red, (float)green, (float)blue, (float)alpha);
    }

    private static void drawTextureWithMasking(Matrix4f matrix, float xCoord, float yCoord, class_1058 textureSprite, long maskTop, long maskRight, float zLevel) {
        float uMin = textureSprite.method_4594();
        float uMax = textureSprite.method_4577();
        float vMin = textureSprite.method_4593();
        float vMax = textureSprite.method_4575();
        uMax -= (float)maskRight / 16.0f * (uMax - uMin);
        vMax -= (float)maskTop / 16.0f * (vMax - vMin);
        RenderSystem.setShader(class_757::method_34542);
        class_289 tessellator = class_289.method_1348();
        class_287 bufferBuilder = tessellator.method_1349();
        bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1585);
        bufferBuilder.method_22918(matrix, xCoord, yCoord + 16.0f, zLevel).method_22913(uMin, vMax).method_1344();
        bufferBuilder.method_22918(matrix, xCoord + 16.0f - (float)maskRight, yCoord + 16.0f, zLevel).method_22913(uMax, vMax).method_1344();
        bufferBuilder.method_22918(matrix, xCoord + 16.0f - (float)maskRight, yCoord + (float)maskTop, zLevel).method_22913(uMax, vMin).method_1344();
        bufferBuilder.method_22918(matrix, xCoord, yCoord + (float)maskTop, zLevel).method_22913(uMin, vMin).method_1344();
        tessellator.method_1350();
    }

    @Override
    public List<class_2561> getTooltip(T fluidStack, class_1836 tooltipFlag) {
        IIngredientTypeWithSubtypes type = this.fluidHelper.getFluidIngredientType();
        class_3611 fluidType = type.getBase(fluidStack);
        try {
            if (fluidType.method_15780(class_3612.field_15906)) {
                return new ArrayList<class_2561>();
            }
            List<class_2561> tooltip = this.fluidHelper.getTooltip(fluidStack, tooltipFlag);
            long amount = this.fluidHelper.getAmount(fluidStack);
            long milliBuckets = amount * 1000L / this.fluidHelper.bucketVolume();
            if (this.tooltipMode == TooltipMode.SHOW_AMOUNT_AND_CAPACITY) {
                class_5250 amountString = class_2561.method_43469((String)"jei.tooltip.liquid.amount.with.capacity", (Object[])new Object[]{nf.format(milliBuckets), nf.format(this.capacity)});
                tooltip.add((class_2561)amountString.method_27692(class_124.field_1080));
            } else if (this.tooltipMode == TooltipMode.SHOW_AMOUNT) {
                class_5250 amountString = class_2561.method_43469((String)"jei.tooltip.liquid.amount", (Object[])new Object[]{nf.format(milliBuckets)});
                tooltip.add((class_2561)amountString.method_27692(class_124.field_1080));
            }
            return tooltip;
        }
        catch (RuntimeException e) {
            class_2561 displayName = this.fluidHelper.getDisplayName(fluidStack);
            LOGGER.error("Failed to get tooltip for fluid: " + displayName, (Throwable)e);
            return new ArrayList<class_2561>();
        }
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    static enum TooltipMode {
        SHOW_AMOUNT,
        SHOW_AMOUNT_AND_CAPACITY,
        ITEM_LIST;

    }
}

